/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8229;

import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.MessageDestination;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.eui.WrongSysOidMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8229.DeviceView.Builder;
import ibm.nways.jdm8229.DeviceView.ChassisLike;
import ibm.nways.jdm8229.eui.ConfigurationFolderGroup;
import ibm.nways.jdm8229.eui.FaultGroup;
import ibm.nways.ras.RAS;
import ibm.nways.web.WebContext;
import java.applet.Applet;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import java.util.ResourceBundle;

public class Jdm8229
extends JdmBrowser {
    public static final Object[][] hub8229Overrides = new Object[][]{{"ibm.nways.mib2.model.RouteTable.Panel.IpRouteDest.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric1.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric2.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric3.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric4.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric5.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteNextHop.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteType.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteAge.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMask.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteType.access", "read-only"}, {"ibm.nways.mib2.model.Interface.Panel.IfAdminStatus.access", "read-only"}, {"ibm.nways.mib2.model.System.Panel.SysContact.length", "60"}, {"ibm.nways.mib2.model.System.Panel.SysName.length", "60"}, {"ibm.nways.mib2.model.System.Panel.SysLocation.length", "60"}, {"ibm.nways.tokenring.model.CrsRingStation.Panel.CrsRemoveStationCommand.access", "read-only"}, {"ibm.nways.tokenring.eui.RemStatusPanel", "ibm.nways.jdm8229.eui.RemStatus8229Panel"}, {"ibm.nways.jdm8229.model.MacBridge.Panel10.MacBridgeStatus.access", "read-only"}};
    private static final String[] oidsSupported = new String[]{"1.3.6.1.4.1.2.6.101", "1.3.6.1.4.1.2.6.23"};
    public static final String bundleName = "ibm.nways.jdm8229.Resources";
    public static final ResourceBundle resBundle = ResourceBundle.getBundle("ibm.nways.jdm8229.Resources");
    private Properties properties;
    Serializable sysOid;
    NavigationFolder root;
    GenModel model;
    private NavigationBrowser tree;
    private boolean deviceIsUp = false;
    private int device = -1;
    private SnmpContextModel contextModel;

    public String getModelTypeName() {
        return "ibm.nways.jdm8229.model.Jdm8229";
    }

    protected synchronized SnmpContextModel getContextModel() {
        block2: {
            if (this.contextModel != null) break block2;
            try {
                this.contextModel = (SnmpContextModel)this.model.getComponent("_ContextInfo");
            }
            catch (Exception exception) {
                this.contextModel = null;
                RAS.logException(19, 3, (Object)this, "getContextModel", exception);
            }
        }
        return this.contextModel;
    }

    public GraphicPanel getDeviceGraphicPanel() {
        GraphicPanel graphicPanel = null;
        try {
            if (this.device >= 0) {
                this.displayMsg(resBundle.getString("startGraphic"));
                if (this.sysOid != null && this.sysOid instanceof OID) {
                    ChassisLike chassisLike = Builder.getInstance().buildChassis(this);
                    chassisLike.draw();
                    graphicPanel = chassisLike.getGraphicPanel();
                }
                this.displayMsg(resBundle.getString("endGraphic"));
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 3, (Object)this, "getDeviceGraphicPanel", exception);
        }
        return graphicPanel;
    }

    private void getInitialDeviceInfo() {
        try {
            ModelInfo modelInfo = this.model.getInfo("Config");
            this.sysOid = modelInfo.get("Config.SysObjectID");
            if (this.sysOid instanceof Timeout || this.sysOid instanceof NotSupported) {
                if (RAS.isEnabled(19, 3)) {
                    RAS.trace(19, 3, (Object)this, "getInitialDeviceInfo", "Can't talk to the Device: " + this.sysOid.toString());
                }
                this.deviceIsUp = false;
                new BoxDownMsg(this.getFrame(), resBundle.getString("IBM8229"));
                return;
            }
            if (this.sysOid instanceof OID) {
                this.device = this.checkSysOid();
            }
            if (this.device < 0) {
                if (RAS.isEnabled(19, 3)) {
                    RAS.logError(19, 3, (Object)this, "getInitialDeviceInfo", "Unknown sysObjectID -> " + this.sysOid);
                }
                new WrongSysOidMsg(this.getFrame(), resBundle.getString("Jdm8260br"));
                this.deviceIsUp = false;
                return;
            }
            this.deviceIsUp = true;
            return;
        }
        catch (Exception exception) {
            this.deviceIsUp = false;
            RAS.logException(19, 3, (Object)this, "getInitialDeviceInfo", exception);
            return;
        }
    }

    protected NavigationPoint getNavTreeRoot() {
        String string = ((Applet)((Object)this)).getParameter("traces");
        if (string != null && string.equals("on")) {
            RAS.enableTrcLog(19, 3);
            RAS.trace(19, 3, (Object)this, "getNavTreeRoot", "Traces have been turned on");
        }
        this.displayMsg(resBundle.getString("askServer"));
        this.model = (GenModel)this.getModel();
        this.displayMsg(resBundle.getString("serverDone"));
        this.getInitialDeviceInfo();
        this.displayMsg(resBundle.getString("createNavigationTree"));
        this.root = this.device >= 0 ? new NavigationFolder(resBundle.getString("IBM8229")) : new NavigationFolder(resBundle.getString("Unknown"));
        NavigationContext navigationContext = this.root.getNavContext();
        new NavFieldOverride(navigationContext, hub8229Overrides);
        return this.root;
    }

    protected void getRestOfNavTree() {
        this.tree = this.getNavigationBrowser();
        NavigationContext navigationContext = this.root.getNavContext();
        navigationContext.put((Object)"TREE", (Object)this.tree);
        if (this.deviceIsUp) {
            try {
                GenModel genModel = (GenModel)this.model.getComponent("ConfigurationFolder");
                ConfigurationFolderGroup configurationFolderGroup = new ConfigurationFolderGroup((JdmBrowser)this, genModel);
                configurationFolderGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)configurationFolderGroup);
                this.root.add((NavigationPoint)configurationFolderGroup);
            }
            catch (Exception exception) {
                RAS.logException(19, 3, (Object)this, "getRestOfNavTree", exception);
            }
        } else {
            NavigationFolder navigationFolder = new NavigationFolder(resBundle.getString("configuration"));
            this.root.add((NavigationPoint)navigationFolder);
            NavigationFolder navigationFolder2 = new NavigationFolder(resBundle.getString("system"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
            navigationFolder.add((NavigationPoint)navigationFolder2);
            NavigationFolder navigationFolder3 = new NavigationFolder(resBundle.getString("general"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
            navigationFolder2.add((NavigationPoint)navigationFolder3);
            SnmpContextModel snmpContextModel = this.getContextModel();
            navigationFolder3.add((NavigationPoint)new NavigationItem(resBundle.getString("snmpConfig"), new NavigationDestination("ibm.nways.jdm.modelgen.SnmpConfigPanel", (RemoteModel)snmpContextModel), "Administration"));
            navigationFolder3.add((NavigationPoint)new NavigationItem(resBundle.getString("perfConfig"), new NavigationDestination("ibm.nways.analysis.dpManager.Admin.DpAdminDestinationPanel", (RemoteModel)snmpContextModel), "Performance Configuration"));
            NavigationItem navigationItem = new NavigationItem(resBundle.getString("communications"), (NavigationDestination)new MessageDestination(resBundle.getString("notConfigured")));
            navigationFolder.add((NavigationPoint)navigationItem);
        }
        this.buildFaultFolder(this.root);
        this.buildTools(this.root);
        this.displayMsg(resBundle.getString("initDone"));
    }

    private void buildTools(NavigationFolder navigationFolder) {
        NavigationFolder navigationFolder2 = new NavigationFolder(resBundle.getString("tools"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        navigationFolder.add((NavigationPoint)navigationFolder2);
        try {
            NavigationBrowser navigationBrowser;
            AnalyzerJdmContext analyzerJdmContext;
            SnmpContextModel snmpContextModel = this.getContextModel();
            ModelInfo modelInfo = snmpContextModel.getConfig();
            String string = modelInfo.get("Config.Address").toString();
            WebContext webContext = new WebContext(string);
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.web.Resources");
            webContext.only_nhd_url();
            NavigationItem navigationItem = new NavigationItem(resourceBundle.getString("weblaunch"), new NavigationDestination("ibm.nways.web.WebBrowserPanel", null), "WebBrowser");
            NavigationContext navigationContext = navigationItem.getNavContext();
            navigationContext.put((Object)"webContext", (Object)webContext);
            navigationFolder2.add((NavigationPoint)navigationItem);
            if (this.getIsApplication()) {
                analyzerJdmContext = new AnalyzerJdmContext(string, this.getServerPortNumber());
                navigationBrowser = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                navigationContext = navigationBrowser.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", (Object)analyzerJdmContext);
                navigationFolder2.add((NavigationPoint)navigationBrowser);
            }
            analyzerJdmContext = new Browser("MIB Browser", (JdmBrowser)this, snmpContextModel);
            navigationBrowser = this.getNavigationBrowser();
            navigationBrowser.addEventListener((NavigationBrowserEventListener)analyzerJdmContext);
            navigationFolder2.add((NavigationPoint)analyzerJdmContext.getRootFolder());
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 3, (Object)this, "buildTools", exception);
            return;
        }
    }

    private void buildFaultFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.model.getComponent("Traps");
        }
        catch (Exception exception) {
            RAS.logException(19, 3, (Object)this, "buildFaultFolder", exception);
        }
        if (genModel != null) {
            FaultGroup faultGroup = new FaultGroup((JdmBrowser)this, this.model);
            faultGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)faultGroup);
            navigationFolder.add((NavigationPoint)faultGroup);
            return;
        }
        navigationFolder.add((NavigationPoint)new NavigationItem(resBundle.getString("fault"), (NavigationDestination)new MessageDestination(resBundle.getString("notConfigured"))));
    }

    private int checkSysOid() {
        int n = -1;
        try {
            int n2 = 0;
            while (true) {
                if (this.sysOid.toString().equals(oidsSupported[n2])) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return n;
    }

    public void dispose() {
        this.sysOid = null;
        this.root = null;
        this.model = null;
        this.tree = null;
        this.contextModel = null;
        super.dispose();
    }

    public Properties getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        try {
            URL uRL = new URL(((Applet)((Object)this)).getDocumentBase(), "properties/Jdm8229.txt");
            Properties properties = new Properties();
            properties.load(uRL.openStream());
            this.properties = properties;
            return properties;
        }
        catch (Exception exception) {
            RAS.logException(19, 3, (Object)this, "getProperties", exception);
            return null;
        }
    }
}

